__PURE_version = 3.11
__PURE_fork = "Pure LCS"
ac.debug(">>> "..__PURE_fork.." WFX",string.format('v%.2f', __PURE_version))
ac.debug(">>> CSP Version", ac.getPatchVersion())



function lerpInv(value, a, b) 
  return (a ~= b and ((value - a) / (b - a)) or 0.0)
end

function lerpInvSat(value, a, b)
  return math.saturateN(lerpInv(value, a, b))
end
--math.lerpInvSat = lerpInvSat
--math.lerpInvSat = function(value, a, b) return 0 end


___PURE___dev_version = false
___TEXTURE__QUALITY = render.TextureFormat.R16G16B16A16.Float
--___TEXTURE__QUALITY = render.TextureFormat.R32G32B32A32.Float


function _d(v)
  ac.debug("---",v)
  return v
end

function PURE_ERR(header_txt, msg_txt)
  ac.debug(header_txt, msg_txt)
end

-- get CSP version
__CSP_version = 0
__CSP_version = ac.getPatchVersionCode()

local __CSP__wrong_version__ = false
__CSP__minimum_version = { 2974, "0.2.3p211" }

if __CSP_version < __CSP__minimum_version[1] then
  __CSP__wrong_version__ = true
end


function get__dirname()
  if ac.dirname then
      return ac.dirname()
  else
      return "assettocorsa\\extension\\weather\\Pure LCS"
  end
end

__pure__path = get__dirname()
function ___reset__Pure___(msg, remain_textures)
  -- set the time of the reset in the backup memeory
  msg = msg or "___reset__Pure___"
  file_write(__pure__path.."\\reset_dummy.lua","w+", msg)
end



__pure__path = get__dirname()
__pure__GAMMA_path = __pure__path..'/../pure'
__pure__render_path = __pure__path.."\\pure\\render\\"
__pure__GAMMA__render_path = __pure__GAMMA_path.."\\render\\"
__pure__custom_ldr_effects_path = ac.getFolder(ac.FolderID.ExtRoot).."/config-ext/PureLdrEffects/"
__pure__custom_hdr_effects_path = ac.getFolder(ac.FolderID.ExtRoot).."/config-ext/PureHdrEffects/"
__pure__path_AC_root = ""
__AC__Root = ac.getFolder(ac.FolderID.Root)

-- build a path string to know the location relative to the ac root folder
local tmp_path = {}
for str in string.gmatch(__pure__path, "([^\\]+)") do
    table.insert(tmp_path, str)
end
local tmp_path_ext_pos = 0
for i=1,#tmp_path do if tmp_path[i]=="extension" then tmp_path_ext_pos=i break end end
if tmp_path_ext_pos > 1 then
    for i=tmp_path_ext_pos, #tmp_path do
        __pure__path_AC_root = __pure__path_AC_root.."\\"..tmp_path[i]
    end
end

-- if a DXGI injector exist (Reshade, DLAA, ...)
__DXGI__INJECTOR = 0


local _l_menu_open = false
function MENU_IS_OPEN()
    return _l_menu_open
end



if not __CSP__wrong_version__ then

  --------
  -- Basic WeatherFX implementation, this is the main file. Sets things up, includes a bunch of stuff and triggers updates.
  --------

  ---Functions from this list will be called when resolution changes.
  ---@type fun()[]
  OnResolutionChange = {}

  ---TODO: Remove once gamma becomes non-changing live.
  ---@type fun()[]
  OnGammaFixChange = {}

  ScriptSettings = ac.INIConfig.scriptSettings():mapConfig({
    LINEAR_COLOR_SPACE = {
      ENABLED = true,
      DIM_EMISSIVES = false,
      DEV_MODE = false
    },
    POSTPROCESSING = {
      LIGHTWEIGHT_REPLACEMENT = false,
      FILM_GRAIN = false
    },
    EXTRA_EFFECTS = {
      UPPER_CLOUDS = true,
      AURORAS = true,
      FOG_ABOVE = true,
      RAIN_HAZE = true,
      LIGHTNING = true,
      ECLIPSE = true,
    },
    PERFORMANCE = {
      ECO = false,
    },
  })
  ScriptSettings.LINEAR_COLOR_SPACE.ENABLED = true

  __ECO__ = ScriptSettings.PERFORMANCE.ECO


  -- Global weather values
  NightK = 0 -- 1 at nights, 0 during the day
  AuroraIntensity = 0
  SunDir = vec3(0, 1, 0)
  MoonDir = vec3(0, 1, 0)
  GodraysColor = rgb()
  CityHaze = 0
  FinalFog = 0
  SpaceLook = 0 -- turns from 0 to 1 as camera gets higher switching to space look of the Earth
  CloudsMult = 0 -- turns to 0 at 4 km to hide clouds
  EclipseFullK = 0 -- starts growing when moon covers sun fully blocking the light, 1 at total eclipse, used for heavy darkening of sky and sun light
  ForceRapidUpdates = 0
  BrightnessMultApplied = 0
  StarsBrightness = 0
  GroundYAveraged = math.nan
  Sim = ac.getSim()


  local lastSunDir = vec3()
  local currentSunDir = vec3()
  local lastGameTime = 0
  --local ruBase = RareUpdate:new{ callback = rareUpdate1 }
  local ruCloudMaterials = nil
  local ruClouds = nil

  local forceUpdateShadingNext = false
  local keepForceUpdates = 1
  RecentlyJumped = 0



  local lightPP_file_loaded = false
  function PUREPP__loadLightPP()
    if not lightPP_file_loaded then
      require 'src/render_postprocessing'
      lightPP_file_loaded = true
    end
  end

  local _l_purelcs_loaded = false
  function load_purelcs()

      --if Sim.isShowroomMode or Sim.isPreviewsGenerationMode then
      --  --ScriptSettings.LINEAR_COLOR_SPACE.ENABLED = false
      --  require 'src/showroom_mode'
      --  require 'src/render_postprocessing'
      --  return
      --end

      if Sim.isShowroomMode or Sim.isPreviewsGenerationMode then
        if __DXGI__INJECTOR < 2 then
          ScriptSettings.POSTPROCESSING.LIGHTWEIGHT_REPLACEMENT = true
        end
      end

--[[
      if Sim.isOnlineRace then
        ScriptSettings.LINEAR_COLOR_SPACE.DEV_MODE = false
      elseif ScriptSettings.LINEAR_COLOR_SPACE.DEV_MODE then
        ui.onExclusiveHUD(function ()
          ui.drawText(UseGammaFix and '[ Linear color space ]' or '[ Gamma color space ]', vec2(8, 8))
        end)
      end
]]
      Overrides = {gamma = ScriptSettings.LINEAR_COLOR_SPACE.ENABLED}
      if ScriptSettings.LINEAR_COLOR_SPACE.DEV_MODE then
        ui.addSettings({icon = ui.Icons.WeatherFewClouds, name = 'WeatherFX style', onOpen = function ()
          Overrides = stringify.tryParse(ac.storage.overrides) or {}
          ForceRapidUpdates = ForceRapidUpdates + 1
        end, onClose = function ()
          Overrides = {gamma = ScriptSettings.LINEAR_COLOR_SPACE.ENABLED}
          ForceRapidUpdates = ForceRapidUpdates - 1
        end}, function ()
          if not Overrides.tint then
            Overrides.tint = rgb.colors.white
          end

          ui.beginGroup(-0.1)
          ui.pushItemWidth(-0.1)
          ui.pushFont(ui.Font.Small)
          if ui.checkbox('Linear color space', Overrides.gamma) then
            Overrides.gamma = not Overrides.gamma
            BrightnessMultApplied = -1
          end

          if ScriptSettings.POSTPROCESSING.LIGHTWEIGHT_REPLACEMENT then
            if ui.checkbox('Original YEBIS post-processing', Overrides.originalPostProcessing) then
              Overrides.originalPostProcessing = not Overrides.originalPostProcessing
            end
          end

          GammaFixBrightnessOffset = ui.slider('##gfbo', GammaFixBrightnessOffset, 1e-6, 10, 'Brightness offset: %.6f', 10)
          GammaFixLightsDivisor = ui.slider('##gfld', GammaFixLightsDivisor, 1e-3, 1e4, 'Lights divisor: %.6f', 10)
          if ui.itemEdited() and UseGammaFix then
            ac.useLinearColorSpace(true, GammaFixLightsDivisor)
          end

          ui.offsetCursorY(12)
          ui.header('Conditions override')
          Overrides.clear = ui.slider('##clear', Overrides.clear or 1, 0, 1, 'Clear: %.3f')
          Overrides.fog = ui.slider('##fog', Overrides.fog or 0, 0, 1, 'Fog: %.3f')
          Overrides.clouds = ui.slider('##clouds', Overrides.clouds or 0, 0, 1, 'Clouds: %.3f')
          Overrides.cloudsDensity = ui.slider('##cloudsDensity', Overrides.cloudsDensity or 0, 0, 1, 'Clouds density: %.3f')
          Overrides.thunder = ui.slider('##thunder', Overrides.thunder or 0, 0, 1, 'Thunder %.3f')
          Overrides.pollution = ui.slider('##pollution', Overrides.pollution or 0, 0, 1, 'Pollution: %.3f')
          Overrides.aurora = ui.slider('##aurora', Overrides.aurora or 0, 0, 1, 'Aurora: %.3f')

          ui.offsetCursorY(12)
          ui.header('Rain')
          Overrides.rain = ui.slider('##rain', Overrides.rain or 0, 0, 1, 'Rain: %.3f')
          Overrides.wetness = ui.slider('##wetness', Overrides.wetness or 0, 0, 1, 'Wetness: %.3f')
          Overrides.water = ui.slider('##water', Overrides.water or 0, 0, 1, 'Water: %.3f')
          Overrides.rainbowIntensity = ui.slider('##rainbowIntensity', Overrides.rainbowIntensity or 0, 0, 1, 'Rainbow: %.3f')

          ui.offsetCursorY(12)
          ui.header('Mood')
          Overrides.saturation = ui.slider('##saturation', Overrides.saturation or 1, 0, 2, 'Saturation: %.3f')

          ui.alignTextToFramePadding()
          ui.text('Tint:')
          ui.sameLine(80)
          ui.colorButton('##tint', Overrides.tint, ui.ColorPickerFlags.PickerHueWheel)

          ui.offsetCursorY(12)
          ui.header('Light pollution')
          Overrides.lightPollution = ui.slider('##lightPollution', Overrides.lightPollution or 0, 0, 3, 'Density: %.3f', 2)
          ui.popItemWidth()
          ui.endGroup()
          ui.popFont()
          if ui.itemEdited() then
            ac.storage.overrides = stringify(Overrides, true)
            BrightnessMultApplied = -1
          end
        end)
      end

      require 'src/consts'                -- some general constant values
      require 'src/utils'                 -- helpful functions

      require 'pure/pure_globals'         -- Pure's globals
      require 'pure/utils/utils_header'   -- helpful functions from Pure

      local injector_file = __AC__Root.."\\dxgi.dll"
      if file_exists(injector_file) then
        __DXGI__INJECTOR = 1
        local f=io.open(injector_file,"r")
        if f~=nil then
          local size = f:seek("end")
          if size > 1e7 then
            -- its probably the DLAA injector
            __DXGI__INJECTOR = 2
          end
          io.close(f) 
        end
      end
      

      require 'src/conditions_converter'  -- thing to turn conditions (esp. weather type) info something usable: a few easy to use numbers
      require 'src/weather_application'   -- most of weather stuff happens here
      require 'src/light_pollution'       -- adds a sky gradient for light pollution and a few global variables like light pollution intensity
  
      --require 'src/audio'                 -- audio
      require 'src/render'                -- render core

      require 'src/render_aurora'         -- auroras
      --require 'src/render_rain'           -- rain haze
      require 'src/render_fog'            -- fog covering tops of high buildings in foggy conditions
      require 'src/render_eclipse'        -- glare around sun during eclipse
      require 'src/render_lightning'      -- simple bolt-like visual for lightnings
      require 'src/render_meteor'         -- falling stars

      -- Pure -> load both, the LIGHTWEIGHT_REPLACEMENT can be activyted in a pp script

      if ScriptSettings.POSTPROCESSING.LIGHTWEIGHT_REPLACEMENT then

        PUREPP__loadLightPP()
        
      --elseif ScriptSettings.LINEAR_COLOR_SPACE.ENABLED or ScriptSettings.LINEAR_COLOR_SPACE.DEV_MODE then
      -- WeatherFX can convert linear to sRGB automatically, but it wouldn’t take our GammaFixBrightnessOffset into
      -- account, and will just use the basic `pow(X, 1/2.2)` conversion too.
      end
      
      require 'src/render_linear'
      --end
      --end

      -- Use asyncronous textures loading for faster loading
      ac.setAsyncTextureLoading(true)

      load_script_file_sys(__pure__path.."\\pure\\utils\\utils_import.json")


      require 'pure/pure_header'

      if not __ECO__ then
        if __PURE__Clouds__method < 1 then
          require 'src/weather_clouds'        -- clouds operating in chunks
          require 'src/render_clouds'         -- upper clouds layer

          -- Since we’re going to use v2 of clouds, here we can set cloud map parameters
          local cloudMap = ac.SkyCloudMapParams.new()
          cloudMap.perlinFrequency = 4.0
          cloudMap.perlinOctaves = 7
          cloudMap.worleyFrequency = 3.0
          cloudMap.shapeMult = 20.0
          cloudMap.shapeExp = 0.5
          cloudMap.shape0Mip = 0
          cloudMap.shape0Contribution = 0.2
          cloudMap.shape1Mip = 2.2
          cloudMap.shape1Contribution = 0.5
          cloudMap.shape2Mip = 3.5
          cloudMap.shape2Contribution = 1.0
          ac.generateCloudMap(cloudMap)

          ac.setCloudShadowDistance(6e3)
          ac.setCloudShadowScalingFactor(1)
        else
          SKYDOMES__init()
        end
      end

      -- Loading textures for sky stuff
      if file_exists(__pure__path.."/pure/space/starmap_16k.dds") ==  true then
        ac.setSkyStarsMap(__pure__path.."/pure/space/starmap_16k.dds")
      elseif file_exists(__pure__path.."/pure/space/starmap_8k.dds") ==  true then
        ac.setSkyStarsMap(__pure__path.."/pure/space/starmap_8k.dds")	
      elseif file_exists(__pure__path.."/pure/space/starmap_4k.dds") ==  true then
        ac.setSkyStarsMap(__pure__path.."/pure/space/starmap_4k.dds")
      else
        ac.setSkyStarsMap('textures/weather_fx/starmap.dds')
      end

      if file_exists(__pure__path.."\\pure\\space\\moon.dds") == true then
        ac.setSkyMoonTexture(__pure__path.."\\pure\\space\\moon.dds")
      else
        ac.setSkyMoonTexture('textures/weather_fx/moon.dds')
      end

      ac.setEarthTexture('textures/weather_fx/earth.dds')
      ac.setSkyMoonGradient(0)

      -- Have to use original size for moon eclipse to look properly:
      ac.setMoonEclipse(true)

      -- Use cloud shadow maps: in this mode, mirrors and reflections will use “ac.getCloudsShadow()” as light multiplier automatically
      ac.setCloudShadowMaps(true)

      -- Do not update cloud maps (like cloud shadows) without manual invalidation
      ac.setManualCloudsInvalidation(true)

      -- Set cloud shadow map parameters
      
      --ac.setCloudShadowIndependantOpacity(true)

      -- Use v2 sky shader
      ac.setSkyUseV2(true)
      ac.setSkyMoonClipThreshold(0.9)
      ac.setCloudArcMultiplier(1)

      -- Use new fog formula (instead of original AC one)
      ac.setFogAlgorithm(ac.FogAlgorithm.New)

      -- As time goes on, some bugs on C++ side are found, in some cases to keep things compatible, fixes need to be enabled manually
      ac.fixSkyColorCalculateResult(true)
      ac.fixSkyColorCalculateOrder(true)
      ac.fixSkyV2Fog(true)
      ac.fixCloudsV2Fog(true)
      if ac.useMinDepthResolution then ac.useMinDepthResolution(true) end

      -- A tweak for lambert diffuse model making lighting of regular materials more correct and PBR-like
      ac.setLambertGamma(UseLambertGammaFix and 1 / 2.2 or 1)

      CloudsDT = 0

--[[
local t_rgb = rgb(-100, 0, 100.0)
local t2_rgb = rgb()
local t_hsv = hsv()
RGBToHSV_To(t_hsv, t_rgb)
HSVToRGB_To(t2_rgb, t_hsv.h, t_hsv.s, t_hsv.v)
_d(t2_rgb)
]]

      __PURE__CPU__add__function_call(ReadConditions, "ReadConditions")
      __PURE__CPU__add__function_call(ApplySky, "ApplySky")
      __PURE__CPU__add__function_call(ApplyLight, "ApplyLight")
      __PURE__CPU__add__function_call(ApplyAmbient, "ApplyAmbient")
      __PURE__CPU__add__function_call(ApplyFog, "ApplyFog")
      __PURE__CPU__add__function_call(ApplySkyFeatures, "ApplySkyFeatures")
      __PURE__CPU__add__function_call(ApplyAdaptiveShadows, "ApplyAdaptiveShadows")
      __PURE__CPU__add__function_call(ApplyReflectionsMultis, "ApplyReflectionsMultis")
      __PURE__CPU__add__function_call(ApplyVAOMultis, "ApplyVAOMultis")
      __PURE__CPU__add__function_call(__PURE__update_stellar_position, "__PURE__update_stellar_position")
      __PURE__CPU__add__function_call(ApplyDaylightMulti, "ApplyDaylightMulti")
      --__PURE__CPU__add__function_call(reset_Pure_config_adjust_HSV_time, "XXX")

      if __ECO__ then
        __PURE__CPU__setOrder({
                                {10, 11, 1, 6, 7, 8, 9},
                                {2,},
                                {3,},
                                {4,},
                                {5,},
                              })
      else
        __PURE__CPU__setOrder({
                                {10, 11, 1, 2, 8},
                                {4, 6, 9},
                                {3, 5, 7},
                              })
      end


      -- Called each 3rd frame, but with an offset, to spread the load
      local function rareUpdate2(dt)
        --ApplyHeatFactor()
        UpdateLightPollution()
        if __PURE__Clouds__method < 1 then
          UpdateCloudMaterials()
        end
        UpdateAurora(dt)
        UpdateAboveFog(dt)
        if __PURE__Clouds__method < 1 then
          UpdateCloudLayers(dt)
        else
          --Clouds__Skydomes_update(dt)
          --__PURE__update_clouds(dt)
        end
      end

      
      lastGameTime = 0
      --ruBase = RareUpdate:new{ callback = rareUpdate1 }
      ruCloudMaterials = RareUpdate:new{ callback = rareUpdate2, phase = 1 }
      if __PURE__Clouds__method < 1 then
        ruClouds = RareUpdate:new{ callback = UpdateClouds, phase = 2 }
      end


      -- init OSD
      --__Pure_OSD_init()
      --ui.onExclusiveHUD(__Pure_OSD_update)

      _l_purelcs_loaded = true

      
      -- Some warnings
      if ScriptSettings.POSTPROCESSING.LIGHTWEIGHT_REPLACEMENT then
        if __DXGI__INJECTOR > 1  and pure.system.isVR() then
          ac.setSystemMessage("DLAA Injector found!", "Alternative Post Processing or the DLAA injection will not work properly...")
        end
      end
  end


  local function getCloudsDeltaT(dt, gameDT)
    local gameTime = ac.getCurrentTime()
    local cloudsDeltaTime = gameTime - lastGameTime
    lastGameTime = gameTime
    local ratio = math.clampN(math.abs(cloudsDeltaTime) / dt - 150, 1, 200)
    return dt * math.sign(cloudsDeltaTime) * math.lerp(1, ratio, 0.4)
  end


  function script.update(dt)

    if Sim~=nil and _l_purelcs_loaded then

      if __AC_SIM.isInMainMenu then
          _l_menu_open = true
      else
          _l_menu_open = false
      end
      
      local curGammaFix = Overrides.gamma ~= false
      if __CSP_version>3044 then
        if Sim.currentVAOMode == ac.VAODebugMode.VAOOnly or Sim.currentVAOMode == ac.VAODebugMode.ShowNormals then
          curGammaFix = false
        end
      end
      if UseGammaFix ~= curGammaFix then
        InitializeConsts(curGammaFix)
        OnGammaToggle()
        ForceRapidUpdates = ForceRapidUpdates + 1
        setTimeout(function ()
          ForceRapidUpdates = ForceRapidUpdates - 1
        end, 0.1)
      end

      -- This value is time passed in seconds (as dt), but taking into account pause, slow
      -- motion or fast forward, but not time scale in conditions
      local gameDT = Sim.dt

      -- Clouds operate on actual passed time
      CloudsDT = TimelapsyCloudSpeed and getCloudsDeltaT(dt, gameDT) or gameDT

      -- If sun moved too much, have to force update
      ac.getSunDirectionTo(currentSunDir)

      local cam_jumped = false
      if __CSP_version>3044 then
        cam_jumped = Sim.cameraJumped
      end
      
      if cam_jumped then
        RecentlyJumped = 5
      elseif RecentlyJumped > 0 then
        RecentlyJumped = RecentlyJumped - 1
      end
      if math.dot(lastSunDir, currentSunDir) < 0.999995 or cam_jumped then
        keepForceUpdates = 1
      end
      local forceUpdate = ForceRapidUpdates > 0
      if keepForceUpdates > 0 then
        forceUpdate = true
        keepForceUpdates = keepForceUpdates - dt
      end
      if forceUpdate then
        lastSunDir:set(currentSunDir)
        ForceRapidUpdates = ForceRapidUpdates + 1
      end

      local groundY = ac.getGroundYApproximation()
      if math.isnan(GroundYAveraged) or cam_jumped then
        GroundYAveraged = groundY
      else
        GroundYAveraged = math.applyLag(GroundYAveraged, groundY, 0.995, dt)
      end

      local forceUpdateShading = forceUpdate
      if forceUpdateShadingNext then
        forceUpdateShading = true
        forceUpdateShadingNext = false
      end

      -- Thunder effect: a small extra gradient glowing in sky
      --if ApplyThunder(gameDT) then
      --  forceUpdateShading = true
      --end

      __PURE_update__pre(dt)

      -- Actual update will happen only once in three frames, or if forceUpdate is true
      --ruBase:update(gameDT, forceUpdateShading)
      __PURE__CPU__update(dt)

      if not __ECO__ then
        if __PURE__Clouds__method > 0 then
          __PURE__update_clouds(dt)
        end

        ruCloudMaterials:update(CloudsDT, forceUpdateShading)

        if __PURE__Clouds__method < 1 then
          -- Increasing refresh rate for faster moving clouds
          if math.abs(CloudsDT) > 0.5 then 
            ruClouds.skip = 0 
            ac.invalidateCloudReflections()
          elseif math.abs(CloudsDT) > 0.05 then 
            ruClouds.skip = 1
            if Sim.frame % 4 == 0 then      
              ac.invalidateCloudReflections()
            end
          elseif math.abs(CloudsDT) < 0.03 then 
            ruClouds.skip = 2
          end
          ruClouds:update(CloudsDT, forceUpdate)
        end
      end

      -- Fake exposure aka eye adaptation needs to update each frame, with speed independant 
      -- from pause, slow motion and what not
      ApplyFakeExposure(dt)
      if ApplyFakeExposure_postponed() then
        forceUpdateShadingNext = true
      end

      -- Rain haze: some sort of volumetric-like effect for distant rain
      --UpdateRainHaze(gameDT)

      -- Uncomment to check how much garbage is generated each frame (slows things down)
      -- RunGC()

      if CurrentConditions.windDir.x == 0 and CurrentConditions.windDir.y == 0 then
        CurrentConditions.windDir:set(CurrentConditions.windDirInstant)
        CurrentConditions.windSpeed = CurrentConditions.windSpeedInstant
      else
        local mix = math.lagMult(0.995, dt)
        CurrentConditions.windDir:scale(1 - mix):addScaled(CurrentConditions.windDirInstant, mix)
        CurrentConditions.windSpeed = math.lerp(CurrentConditions.windSpeed, CurrentConditions.windSpeedInstant, mix)
      end

      __PURE_update__post(dt)

      --if ac.configureGrassShading~=nil then
      --  ac.configureGrassShading(0.025, 0.05)
      --end

      -- update the render/shaders
      if not __ECO__ then
        __PURE__update_render(dt)
      end

      --if not __withAsyncUpdate then
      --  script.asyncUpdate(dt)
      --end

      if not __ECO__ then
        if Sim~=nil and _l_purelcs_loaded then
          if __PURE__Clouds__method > 0 then
            __PURE__async_update_clouds(dt)
          end
          __PURE__async_update_render(dt)
        end
      end

      if __PURE__get_config("debug.memory") then
        runGC()
        printGC()
      end
    else
      Sim = ac.getSim()
      if Sim~=nil then
          --if Sim.isPostProcessingActive == ac.isPpActive() then
              load_purelcs()
          --end
      end
    end
  end

  
  --function script.asyncUpdate(dt)
  --  if not __ECO__ then
  --    if Sim~=nil and _l_purelcs_loaded then
  --      if __PURE__Clouds__method > 0 then
  --        __PURE__async_update_clouds(dt)
  --      end
  --      __PURE__async_update_render(dt)
  --    end
  --  end
  --end


  --function script.frameBegin(dt)
  --  if _l_purelcs_loaded then
  --    -- Update audio (for now, just rain)
  --    --ApplyAudio(dt)
  --  end
  --end

  -- To stop script from reloading with resolution changes, adding a subscription to the event
  ac.onResolutionChange(function (newSize, makingScreenshot)
    ac.log('Resolution change', newSize, makingScreenshot)

    -- Instead of manually disposing all created textures, the idea is to clear out all the tables
    -- containing those and then run garbage collector and let CSP clean things up automatically
    for _, v in ipairs(OnResolutionChange) do v() end
    collectgarbage('collect')
  end)

else

  require ("pure/utils/utils_wrongCSP")

  function script.update(dt)
    show_incompatible_CSP_version(--[[__CSP__minimum_version]])
  end
end
